#!/bin/sh
product=mpgedit_0.6
install_root=/usr/local

man1="decoder.so.1 mp3decoder.sh.1 mpgedit.1"
lib="libdecoder_mpg123.so libdecoder_popen.so libmpglib_mpgedit.so"
bin="mpgedit mpgedit_nocurses mp3decoder.sh"

do_install()
{
  get_install_root
  
  echo "Installing '$product' in '$install_root'"
  install -d $install_root/man/man1
  install -d $install_root/lib
  install -d $install_root/bin
  
  echo "Installing man pages ($install_root/man/man1)..."
  install -m 444 $man1 $install_root/man/man1
  
  echo "Installing shared libraries ($install_root/lib)..."
  install $lib $install_root/lib
  
  echo "Installing executables ($install_root/bin)..."
  install $bin $install_root/bin
  
  rm -f $install_root/lib/libmpgedit_decoder.so
  ln -s $install_root/lib/libdecoder_mpg123.so \
        $install_root/lib/libmpgedit_decoder.so
  
  line=`grep $install_root/lib /etc/ld.so.conf`
  if [ -z "$line" ]; then
    echo
    echo "$install_root/lib not found in /etc/ld.co.conf"
    echo "This is needed for proper operation of mpgedit"
    echo
    echo -n "  Do you want to add this now? [Y/n] "
    read line
    line=`echo $line | tr '[A-Z]' '[a-z]'`
    if [ "$line" != "n" -a "$line" != "no" ]; then
      echo "$install_root/lib" >> /etc/ld.so.conf
      /sbin/ldconfig
    fi
  fi
  echo "Finished installing '$product'"
  echo
  echo "Remember to add '$install_root/bin' to your PATH environment variable"
  echo "Remember to add '$install_root/man/man1' to your MANPATH environment variable"
}


do_uninstall()
{
  get_install_root "un"
  if [ ! -d "$install_root" ]; then
    echo "ERROR: uninstall directory does not exist"
    exit 1
  fi

  echo "Uninstalling '$product' in '$install_root'"
  for i in $man1; do
    if [ -f $install_root/man/man1/$i ]; then
      echo "rm -f $install_root/man/man1/$i"
            rm -f $install_root/man/man1/$i
    fi
  done
  for i in $lib; do
    if [ -f $install_root/lib/$i ]; then
      echo "rm -f $install_root/lib/$i"
            rm -f $install_root/lib/$i
    fi
  done
  for i in $bin; do
    if [ -f $install_root/bin/$i ]; then
     echo "rm -f $install_root/bin/$i"
           rm -f $install_root/bin/$i
    fi
  done
  if [ -h $install_root/lib/libmpgedit_decoder.so ]; then
    echo "rm -f $install_root/lib/libmpgedit_decoder.so"
          rm -f $install_root/lib/libmpgedit_decoder.so
  fi
  echo "Finished uninstalling '$product' in '$install_root'"
}


get_install_root()
{
  prefix=$1
  echo "Current ${prefix}install location is '$install_root'"
  echo -n "  Change location? [y/N] "
  read line
  line=`echo $line | tr '[A-Z]' '[a-z]'`
  if [ "$line" = "y" -o "$line" = "yes" ]; then
    ok=no
    echo
    while [ "$ok" = "no" ]; do
      echo "Enter ${prefix}install directory"
      read new_install_root
      echo "New ${prefix}install directory: '$new_install_root'"
      echo -n "  Is this correct? "
      read line
      line=`echo $line | tr '[A-Z]' '[a-z]'`
      if [ "$line" = "y" -o "$line" = "yes" ]; then
        ok="yes"
      fi
    done
    install_root=$new_install_root
  fi
}

#
# ============================ main =======================
#
uid=`id | sed -e 's/uid=\([0-9][0-9]*\).*/\1/'`
if [ $uid != 0 ]; then
  echo "ERROR: Can only install '$product' as root"
  exit 1;
fi

if [ -z "$1" ]; then
  do_install
  exit 0
elif [ -n "$1" ]; then
  t=`echo "x$1" | grep '^x-u$'`
  if [ -n "$t" ]; then
    do_uninstall
    un="un"
    exit 0
  else
    echo "unrecognized option '$1'"
  fi
fi
